// User types
export type {
  User,
  UserLevel,
  Badge,
  UserPreferences,
  UserStats,
  LoginCredentials,
  RegisterData,
  PasswordResetRequest,
  PasswordResetConfirm,
  UpdateProfileData,
} from './user'

// Task types
export type {
  Task,
  TaskType,
  TaskCategory,
  TaskDifficulty,
  TaskStatus,
  TaskSponsor,
  UserTask,
  UserTaskStatus,
  TaskFilter,
  TaskSubmission,
  TaskReview,
  ListenEarnTask,
  ListenEarnQuestion,
  SurveyTask,
  SurveyQuestion,
} from './task'

// Blog types
export type {
  BlogPost,
  BlogAuthor,
  BlogCategory,
  BlogStatus,
  BlogComment,
  BlogFilter,
  CreateBlogPost,
  UpdateBlogPost,
  BlogStats,
  RelatedPost,
} from './blog'

// Support types
export type {
  SupportTicket,
  SupportCategory,
  SupportPriority,
  SupportStatus,
  SupportMessage,
  SupportAttachment,
  CreateSupportTicket,
  UpdateSupportTicket,
  CreateSupportMessage,
  SupportFilter,
  SupportStats,
  FAQ,
  FAQCategory,
  ContactForm,
} from './support'

// API types
export * from './api'

// Common types
export interface ApiResponse<T = unknown> {
  success: boolean
  data?: T
  message?: string
  errors?: Record<string, string[]>
  meta?: {
    pagination?: {
      page: number
      limit: number
      total: number
      totalPages: number
    }
  }
}

export interface PaginationParams {
  page?: number
  limit?: number
}

export interface SortParams {
  sortBy?: string
  sortOrder?: 'asc' | 'desc'
}

export interface SearchParams {
  search?: string
}

export interface DateRangeParams {
  startDate?: string
  endDate?: string
}

// Navigation types
export interface MenuItem {
  id: string
  label: string
  href: string
  icon?: string
  isPublic?: boolean
  children?: MenuItem[]
}

export interface NavbarLink {
  label: string
  href: string
  isExternal?: boolean
}

// Form types
export interface FormField {
  name: string
  label: string
  type: 'text' | 'email' | 'password' | 'tel' | 'textarea' | 'select' | 'checkbox' | 'radio' | 'file' | 'date'
  placeholder?: string
  required?: boolean
  validation?: {
    pattern?: string
    minLength?: number
    maxLength?: number
    min?: number
    max?: number
  }
  options?: { value: string; label: string }[]
}

export interface FormError {
  field: string
  message: string
}

// Modal types
export interface ModalProps {
  isOpen: boolean
  onClose: () => void
  title?: string
  size?: 'sm' | 'md' | 'lg' | 'xl'
  closeOnBackdrop?: boolean
  closeOnEscape?: boolean
}

// Notification types
export interface Notification {
  id: string
  type: 'success' | 'error' | 'warning' | 'info'
  title: string
  message?: string
  duration?: number
  action?: {
    label: string
    onClick: () => void
  }
}

// Chat types
export interface ChatMessage {
  id: string
  userId: string
  username: string
  avatar?: string
  message: string
  timestamp: string
  type: 'text' | 'emoji' | 'system'
}

export interface ChatRoom {
  id: string
  name: string
  description?: string
  isActive: boolean
  userCount: number
  maxUsers?: number
  messages: ChatMessage[]
}

// Wallet/Balance types
export interface WalletTransaction {
  id: string
  userId: string
  type: 'earn' | 'withdraw' | 'bonus' | 'penalty' | 'refund'
  amount: number
  description: string
  status: 'pending' | 'completed' | 'failed' | 'cancelled'
  createdAt: string
  processedAt?: string
  reference?: string
  taskId?: string
  withdrawalMethod?: string
  bankAccount?: string
}

export interface WithdrawalRequest {
  amount: number
  method: 'bank_transfer' | 'papara' | 'ininal' | 'other'
  accountInfo: Record<string, string>
  note?: string
}

// Referral types
export interface Referral {
  id: string
  referrerId: string
  referredId: string
  referredUser: {
    id: string
    username: string
    firstName: string
    lastName: string
    joinedAt: string
    isActive: boolean
  }
  status: 'pending' | 'active' | 'inactive'
  createdAt: string
  totalEarnings: number
  commission: number
  commissionRate: number
}

export interface ReferralStats {
  totalReferrals: number
  activeReferrals: number
  totalCommission: number
  monthlyCommission: number
  conversionRate: number
  averageUserValue: number
}