export interface Task {
  id: string
  title: string
  description: string
  type: TaskType
  category: TaskCategory
  difficulty: TaskDifficulty
  reward: number
  estimatedTime: number // dakika cinsinden
  requirements: string[]
  instructions: string[]
  images?: string[]
  externalUrl?: string
  status: TaskStatus
  createdAt: string
  updatedAt: string
  expiresAt?: string
  maxParticipants?: number
  currentParticipants: number
  tags: string[]
  rating: number
  ratingCount: number
  isSponsored: boolean
  sponsor?: TaskSponsor
}

export type TaskType = 'micro' | 'macro' | 'survey' | 'listen'

export type TaskCategory = 
  | 'social_media'
  | 'survey'
  | 'content_creation'
  | 'data_entry'
  | 'testing'
  | 'research'
  | 'translation'
  | 'audio'
  | 'video'
  | 'other'

export type TaskDifficulty = 'easy' | 'medium' | 'hard'

export type TaskStatus = 
  | 'pending'
  | 'in_progress'
  | 'completed'
  | 'rejected'
  | 'expired'
  | 'cancelled'

export interface TaskSponsor {
  id: string
  name: string
  logo: string
  website?: string
  description?: string
}

export interface UserTask {
  id: string
  taskId: string
  userId: string
  status: UserTaskStatus
  startedAt: string
  completedAt?: string
  submittedAt?: string
  approvedAt?: string
  rejectedAt?: string
  rejectionReason?: string
  submissionData?: Record<string, unknown>
  rating?: number
  review?: string
  earnedAmount: number
  proofImages?: string[]
  proofVideos?: string[]
  proofText?: string
}

export type UserTaskStatus = 
  | 'started'
  | 'submitted'
  | 'approved'
  | 'rejected'
  | 'expired'

export interface TaskFilter {
  type?: TaskType[]
  category?: TaskCategory[]
  difficulty?: TaskDifficulty[]
  minReward?: number
  maxReward?: number
  maxTime?: number
  isSponsored?: boolean
  tags?: string[]
  sortBy?: 'reward' | 'time' | 'rating' | 'created_at'
  sortOrder?: 'asc' | 'desc'
}

export interface TaskSubmission {
  taskId: string
  submissionData: Record<string, unknown>
  proofImages?: File[]
  proofVideos?: File[]
  proofText?: string
  completedAt: string
}

export interface TaskReview {
  id: string
  taskId: string
  userId: string
  rating: number
  comment?: string
  createdAt: string
  isVerified: boolean
}

export interface ListenEarnTask extends Task {
  audioUrl: string
  audioDuration: number // saniye cinsinden
  transcription?: string
  questions?: ListenEarnQuestion[]
  minListenPercentage: number // %80 gibi
}

export interface ListenEarnQuestion {
  id: string
  question: string
  options?: string[]
  correctAnswer?: string
  points: number
}

export interface SurveyTask extends Task {
  questions: SurveyQuestion[]
  targetAudience?: {
    minAge?: number
    maxAge?: number
    gender?: ('male' | 'female' | 'other')[]
    location?: string[]
    interests?: string[]
  }
}

export interface SurveyQuestion {
  id: string
  type: 'multiple_choice' | 'text' | 'rating' | 'yes_no' | 'checkbox'
  question: string
  options?: string[]
  required: boolean
  validation?: {
    minLength?: number
    maxLength?: number
    pattern?: string
  }
}