export interface User {
  id: string
  username: string
  email: string
  phone: string
  firstName: string
  lastName: string
  birthDate: string
  gender: 'male' | 'female' | 'other'
  avatar?: string
  bio?: string
  createdAt: string
  updatedAt: string
  isActive: boolean
  isVerified: boolean
  balance: number
  totalEarnings: number
  referralCode: string
  referredBy?: string
  level: UserLevel
  badges: Badge[]
  preferences: UserPreferences
}

export interface UserLevel {
  id: number
  name: string
  minPoints: number
  maxPoints: number
  benefits: string[]
  color: string
}

export interface Badge {
  id: string
  name: string
  description: string
  icon: string
  unlockedAt: string
  rarity: 'common' | 'rare' | 'epic' | 'legendary'
}

export interface UserPreferences {
  notifications: {
    email: boolean
    push: boolean
    sms: boolean
    taskReminders: boolean
    referralUpdates: boolean
    promotions: boolean
  }
  privacy: {
    showProfile: boolean
    showStats: boolean
    allowDirectMessages: boolean
  }
  language: string
  timezone: string
}

export interface UserStats {
  totalTasks: number
  completedTasks: number
  pendingTasks: number
  rejectedTasks: number
  successRate: number
  averageRating: number
  totalReferrals: number
  activeReferrals: number
  monthlyEarnings: number
  allTimeEarnings: number
  currentStreak: number
  longestStreak: number
}

export interface LoginCredentials {
  identifier: string // username veya email
  password: string
  rememberMe?: boolean
}

export interface RegisterData {
  email: string
  password: string
  confirmPassword: string
  username: string
  firstName: string
  lastName: string
  phone: string
  birthDate: string
  gender: 'male' | 'female' | 'other'
  agreeToTerms: boolean
  agreeToPrivacy: boolean
  referralCode?: string
}

export interface PasswordResetRequest {
  email: string
}

export interface PasswordResetConfirm {
  email: string
  code: string
  newPassword: string
  confirmPassword: string
}

export interface UpdateProfileData {
  firstName?: string
  lastName?: string
  phone?: string
  bio?: string
  avatar?: File
  preferences?: Partial<UserPreferences>
}