<?php

namespace App\Filament\Pages;

use Filament\Forms\Components\Section;
use Filament\Forms\Form;
use Filament\Pages\Page;
use LaraZeus\Qr\Components\Qr;

class QrCode extends Page
{
    protected static ?string $navigationIcon = 'heroicon-m-qr-code';
    protected static ?string $navigationGroup = 'Ayarlar';
    protected static ?string $navigationLabel = 'QR Oluşturucu';
    protected static ?string $pluralModelLabel = 'QR Oluşturucu';
    protected static ?int $navigationSort = 3;
    protected static ?string $slug = 'qr-olusturucu';
    protected static string $view = 'filament.pages.qrcode';
    public function getTitle(): string
    {
        return 'QR Oluşturucu';
    }

    public ?array $data = [];

    public function mount(): void
    {
        $this->form->fill();
    }

    public function form(Form $form): Form
    {
        return $form
            ->statePath('data')
            ->schema([
                Section::make()
                    ->heading('QR Kodu Oluşturucu')
                    ->schema([
                        ...\LaraZeus\Qr\Facades\Qr::getFormSchema(
                            statePath: 'text',
                            optionsStatePath: 'text-options'
                        ),
                    ]),
            ]);
    }
}
