<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ContactResource\Pages;
use App\Models\Contact;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Notifications\Notification;
use Filament\Support\Exceptions\Halt;

class ContactResource extends Resource
{
    protected static ?string $model = Contact::class;
    protected static ?string $navigationGroup = 'Ana Sayfa';
    protected static ?string $navigationLabel = 'İletişim';
    protected static ?string $pluralModelLabel = 'İletişim';
    protected static ?int $navigationSort = 7;
    protected static ?string $slug = 'iletisim';
    protected static ?string $navigationIcon = 'heroicon-o-phone';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('subject')
                    ->label('Mesaj')
                    ->required()
                    ->maxLength(255)
                    ->placeholder('Konu giriniz')
                    ->columnSpanFull(),
            ])->columns([
                'sm' => 1,
                'md' => 1,
                'lg' => 1,  
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc') 
            ->columns([
                Tables\Columns\TextColumn::make('subject')
                    ->label('Mesaj')
                    ->searchable()
                    ->sortable()
                    ->limit(50),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make()->label('Görüntüle'),
                Tables\Actions\DeleteAction::make()->label('Sil')
                    ->before(function () {
                        if (config('app.demo', false)) {
                            Notification::make()
                                ->danger()
                                ->title('Demo modunda silme yapılamaz.')
                                ->send();

                            throw new Halt();
                        }
                    }),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()
                        ->before(function () {
                            if (config('app.demo', false)) {
                                Notification::make()
                                    ->danger()
                                    ->title('Demo modunda toplu silme yapılamaz.')
                                    ->send();

                                throw new Halt();
                            }
                        }),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function canCreate(): bool
    {
        return false;
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListContacts::route('/'),
            'create' => Pages\CreateContact::route('/create'),
        ];
    }
}
