<?php

namespace App\Filament\Resources\KategoriResource\Pages;

use App\Filament\Resources\KategoriResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Notifications\Notification;

class ListKategoris extends ListRecords
{
    protected static string $resource = KategoriResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make()
                ->before(function () {
                    if (config('app.demo', false)) {
                        Notification::make()
                            ->danger()
                            ->title('Demo modunda bu işlem yapılamaz.')
                            ->send();

                        $this->halt(); // Oluşturmayı durdurur
                    }
                }),
        ];
    }
}
