<?php

namespace App\Filament\Resources;

use App\Filament\Resources\VitrinResource\Pages;
use App\Models\Vitrin;
use App\Models\Yemekler;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\IconColumn;
use Filament\Notifications\Notification;
use Filament\Support\Exceptions\Halt;
use Illuminate\Database\Eloquent\Model;

class VitrinResource extends Resource
{
    protected static ?string $model = Vitrin::class;

    protected static ?string $navigationGroup = 'Ana Sayfa';
    protected static ?string $navigationLabel = 'Vitrin';
    protected static ?string $pluralModelLabel = 'Vitrinler';
    protected static ?int $navigationSort = 6;
    protected static ?string $slug = 'vitrin';
    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Select::make('yemek_id')
                    ->label('Yemek Seç')
                    ->options(Yemekler::pluck('name', 'id'))
                    ->searchable()
                    ->required()
                    ->rules(function (?Model $record) {
                        $ignoreId = $record?->id ?? 'NULL';
                        return ['unique:vitrins,yemek_id,' . $ignoreId];
                    }),

                Toggle::make('status')
                    ->label('Aktif mi?')
                    ->onColor('success')
                    ->offColor('danger'),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('yemek.name')
                    ->label('Yemek Adı')
                    ->sortable()
                    ->searchable(),

                IconColumn::make('status')
                    ->boolean()
                    ->label('Durum')
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make()
                    ->before(function () {
                        if (config('app.demo', false)) {
                            Notification::make()
                                ->danger()
                                ->title('Demo modunda bu işlem yapılamaz.')
                                ->send();

                            throw new Halt();
                        }
                    }),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()
                        ->before(function () {
                            if (config('app.demo', false)) {
                                Notification::make()
                                    ->danger()
                                    ->title('Demo modunda bu işlem yapılamaz.')
                                    ->send();

                                throw new Halt();
                            }
                        }),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListVitrins::route('/'),
            'create' => Pages\CreateVitrin::route('/create'),
            'edit' => Pages\EditVitrin::route('/{record}/edit'),
        ];
    }
}
