<?php

namespace App\Filament\Resources\VitrinResource\Pages;

use App\Filament\Resources\VitrinResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Notifications\Notification;
use Filament\Support\Exceptions\Halt;

class CreateVitrin extends CreateRecord
{
    protected static string $resource = VitrinResource::class;

    protected function beforeCreate(): void
    {
        if (config('app.demo', false)) {
            Notification::make()
                ->danger()
                ->title('Demo modunda bu işlem yapılamaz.')
                ->send();

            throw new Halt(); // Kaydı durdurur
        }
    }
}
