<?php

namespace App\Http\Controllers;

use App\Models\Contact;  // EKLENDİ
use App\Models\Kategori;
use App\Models\Vitrin;
use App\Models\WeeklyMenu;
use App\Models\Yemekler;
use Joaopaulolndev\FilamentGeneralSettings\Models\GeneralSetting;
use Illuminate\Http\Request;

class IndexController extends Controller
{
    public function index()
    {
        $settings = GeneralSetting::first(); 
$moreConfigs = $settings->more_configs;
       $kategoriler = Kategori::where('is_active', true)
    ->orderBy('order') 
    ->get();


        $vitrins = Vitrin::with('yemek')
            ->where('status', true)
            ->get();

            $weeklyMenu = WeeklyMenu::with('yemek')->latest()->first();

        return view('index', compact('kategoriler', 'vitrins', 'settings', 'moreConfigs', 'weeklyMenu'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'subject' => 'required|max:255',
        ]);

        $contact = new Contact();
        $contact->subject = $request->subject;
        $contact->save();

        return redirect()->route('index')->with('success', 'Mesajınız başarıyla gönderildi.');
    }
}
