<?php

namespace App\Http\Controllers;

use App\Models\Kategori;
use Joaopaulolndev\FilamentGeneralSettings\Models\GeneralSetting;
use Illuminate\Http\Request;

class KategoriController extends Controller
{
  public function show($slug)
{
    $kategori = Kategori::with('yemekler')->where('slug', $slug)->firstOrFail();

    if (!$kategori->is_active) {
        return redirect()->route('index')->with('error', 'Aradığınız kategori aktif değil.');
    }

    if ($kategori->yemekler->isEmpty()) {
        return redirect()->route('index')->with('error', 'Bu kategoride henüz içerik bulunmamaktadır.');
    }

    $settings = GeneralSetting::first(); 
    $moreConfigs = $settings->more_configs;

    return view('category', compact('kategori', 'settings', 'moreConfigs'));
}

}
