<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class DemoMode
{
    public function handle(Request $request, Closure $next)
    {
        if (config('app.demo', false)) {
            // POST, PUT, PATCH, DELETE isteklerini engelle
            if (in_array($request->method(), ['POST', 'PUT', 'PATCH', 'DELETE'])) {
                return redirect()->back()->with('error', 'Demo modunda değişiklik yapamazsınız.');
            }
        }

        return $next($request);
    }
}
