<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Kategori;
use App\Models\Vitrin;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Yemekler extends Model
{
    use HasFactory;

    protected $table = 'yemekler';

    protected $fillable = [
        'kategori_id',
        'name',
        'image',
        'description',
        'price',
        'is_active',
        'vitrin',
    ];

    // Kategori ile ters ilişki
    public function kategori()
    {
        return $this->belongsTo(Kategori::class);
    }
}
