<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Illuminate\Support\Str;
use DB;


class DemoIcerikSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $kategoriler = [
            [
                'name' => 'Ana Yemekler',
                'image' => 'anayemekler.jpg',
            ],
            [
                'name' => 'Güne Başlarken',
                'image' => 'gunebaslarken.jpg',
            ],
            [
                'name' => 'Hamburger',
                'image' => 'hamburger.jpg',
            ],
            [
                'name' => 'Meyveler',
                'image' => 'meyveler.jpg',
            ],
            [
                'name' => 'Salatalar',
                'image' => 'salatalar.jpg',
            ],
            [
                'name' => 'Sıcak İçecekler',
                'image' => 'sicakicecekler.jpg',
            ],
            [
                'name' => 'Soğuk İçecekler',
                'image' => 'sogukicecekler.jpg',
            ],
            [
                'name' => 'Tatlılar',
                'image' => 'tatlilar.jpg',
            ],
        ];

        foreach ($kategoriler as $index => $kategori) {
            DB::table('kategoris')->insert([
                'name' => $kategori['name'],
                'image' => 'assets/images/' . $kategori['image'],
                'is_active' => true,
                'order' => $index + 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }

        DB::table('general_settings')->insert([
            'site_name' => 'QR Menü',
            'site_description' => 'Müşterilerinize hızlı, hijyenik ve modern bir menü deneyimi sunun. QR Menü sayesinde işletmeniz için saniyeler içinde bir dijital menü oluşturun, QR kodunuzu alın ve hemen kullanmaya başlayın.
Üstelik özel tasarımlar, kolay yönetim paneli ve mobil uyumlu yapısıyla menüleriniz her zaman cebinizde!',
            'site_logo' => 'assets/site_logo.png',
            'theme_color' => '#2f4156',
            'more_configs' => json_encode([
                'restoran_image' => 'https://i.hizliresim.com/m7h75gj.jpg',
                'restoran_adres' => 'İstanbul 34000'
            ]),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);

         DB::table('users')->insert([
            'name' => 'demo',
            'email' => 'demo@gmail.com',
            'email_verified_at' => Carbon::now(),
            'password' => Hash::make('12345'), // Şifreyi güvenli şekilde hash'ledik
            'remember_token' => Str::random(10),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
    }
}
