document.addEventListener("DOMContentLoaded", function () {
    // Menü
    const menuToggle = document.getElementById('menu-toggle');
    const sideMenu = document.getElementById('side-menu');
    const closeMenu = document.getElementById('close-menu');
    const overlay = document.getElementById('overlay');

    if (menuToggle && sideMenu && closeMenu && overlay) {
        menuToggle.addEventListener('click', () => {
            sideMenu.classList.add('active');
            overlay.classList.add('active');
        });

        const closeSideMenu = () => {
            sideMenu.classList.remove('active');
            overlay.classList.remove('active');
        };

        closeMenu.addEventListener('click', closeSideMenu);
        overlay.addEventListener('click', closeSideMenu);
    }

    // Modal
    const modal = document.querySelector('.modal');
    const modalImg = document.getElementById('modalImg');
    const modalName = document.getElementById('modalName');
    const modalDesc = document.getElementById('modalDesc');
    const modalButton = document.getElementById('modalButton');
    const closeBtn = document.querySelector('.modal .close');

    document.querySelectorAll('.clickable-item').forEach(item => {
        item.addEventListener('click', () => {
            const name = item.dataset.name;
            const img = item.dataset.img;
            const button = item.dataset.button || 'Fiyat Girilmemiş';
            const desc = item.dataset.desc || 'Açıklama Girilmemiş';
            if (!name || !img) return;

            modalImg.src = img;
            modalImg.alt = name;
            modalName.textContent = name;
            modalDesc.textContent = desc;
            modalButton.textContent = button;
            modal.classList.add('show');
        });
    });

    // Modal kapatma
    if (closeBtn && modal) {
        closeBtn.addEventListener('click', () => modal.classList.remove('show'));
        modal.addEventListener('click', e => {
            if (e.target === modal) modal.classList.remove('show');
        });
    }

    // Feedback
    const feedbackBtn = document.getElementById('sendFeedback');
    const feedbackInput = document.getElementById('feedback');

    if (feedbackBtn && feedbackInput) {
        feedbackBtn.addEventListener('click', () => {
            const txt = feedbackInput.value.trim();
            if (!txt) {
                alert('Lütfen mesajınızı yazın.');
            } else {
                alert('Mesajınız alındı, teşekkürler!');
                feedbackInput.value = '';
            }
        });
    }
});
