@extends('layouts.qr-layout')

@push('styles')
    
@endpush


@push('content')
<div class="app">

    <!-- 1) Bunları Beğenebilirsiniz -->
    @php
        $vitrinYemekler = $kategori->yemekler->where('vitrin', true)->where('is_active', true);
    @endphp

    @if ($vitrinYemekler->isNotEmpty())
        <section class="recommendations animate-in">
            <h2>Müşterilerimizin seçtikleri</h2>
            <div class="rec-list">
                @foreach ($vitrinYemekler as $yemek)
                    <div class="rec-item clickable-item"
                         data-name="{{ $yemek->name }}"
                         data-button="{{ number_format($yemek->price, 2, ',', '.') }}₺"
                         data-img="{{ $yemek->image 
    ? asset('storage/' . $yemek->image) 
    : asset('assets/images/resimYok.jpg') }}"
                         data-desc="{{ $yemek->description }}">
                        <div class="rec-thumb">
                            <img src="{{ $yemek->image 
    ? asset('storage/' . $yemek->image) 
    : asset('assets/images/resimYok.jpg') }}" alt="{{ $yemek->name }}" />
                        </div>
                        <span>{{ $yemek->name }}</span>
                        <p>{{ number_format($yemek->price, 2, ',', '.') }}₺</p>
                    </div>
                @endforeach
            </div>
        </section>
  
<hr class="animate-in delay-1">
    @endif
<h2 style="
    font-weight: 400;
    background: linear-gradient(to right, var(--accent-solid), rgba(173, 41, 41, 0));
    font-size: 14px;
    color: var(--accent);
    margin: 2rem 1rem 0 1rem;
    text-align: left;
    padding: 10px 1rem;
    border-radius: 10px;
    ">{{ $kategori->name }}</h2>
 <!-- 3) 8 kutucuk -->
    <section class="grid-eight animate-in delay-2">
      @foreach($kategori->yemekler
        ->where('is_active', 1)
        ->sortBy(fn($yemek) => $yemek->order) as $yemek)
    <div class="kategori-item clickable-item" 
         data-name="{{ $yemek->name }}" 
         data-img="{{ $yemek->image 
    ? asset('storage/' . $yemek->image) 
    : asset('assets/images/resimYok.jpg') }}"
         data-desc="{{ $yemek->description }}"
         data-button="{{ number_format($yemek->price, 2, ',', '.') }}₺">
        <div class="kategori-thumb">
            <img src="{{ $yemek->image 
    ? asset('storage/' . $yemek->image) 
    : asset('assets/images/resimYok.jpg') }}" alt="{{ $yemek->name }}">
        </div>
        <span>{{ $yemek->name }}</span>
        <p>{{ number_format($yemek->price, 2, ',', '.') }}₺</p>
    </div>
@endforeach


    
    </section>

    <footer class="footer animate-in delay-6">
    <div class="footer-bottom reveal" style="transition-delay:0.6s;"><span id="current-year"></span>DESIGNED BY A</p>
    </div>
  </footer>

  </div>
@endpush

@push('js')
    
@endpush